@echo off
title Consumer ESU Enrollment Tool
color 0A

:menu
cls
echo ===============================================
echo        Consumer ESU Enrollment - Tool
echo ===============================================
echo.
echo 1) Enable Consumer ESU (Fast Method - registry only)
echo 2) Enable Consumer ESU (Full Method - recommended if Fast fails)
echo 3) Check Eligibility (use after restart)
echo 4) Disable Consumer ESU (remove feature)
echo 5) Exit
echo.
set /p choice=Choose an option: 

if "%choice%"=="1" goto :enablefast
if "%choice%"=="2" goto :enablefull
if "%choice%"=="3" goto :check
if "%choice%"=="4" goto :disable
if "%choice%"=="5" exit
goto :menu

:enablefast
echo.
echo [*] Enabling Consumer ESU feature (Fast Method)...
sc.exe config DiagTrack start= auto >nul 2>&1
sc.exe start DiagTrack >nul 2>&1

reg.exe add "HKLM\SYSTEM\CurrentControlSet\Policies\Microsoft\FeatureManagement\Overrides" /v 4011992206 /t REG_DWORD /d 2 /f

echo.
echo [*] Consumer ESU feature enabled (Fast Method).
echo [!] Please RESTART your computer NOW.
echo [!] After restart, run this script again and choose option 3 to check eligibility.
pause
goto :menu

:enablefull
echo.
echo [*] Enabling Consumer ESU feature (Full Method)...
sc.exe config DiagTrack start= auto >nul 2>&1
sc.exe start DiagTrack >nul 2>&1

reg.exe add "HKLM\SYSTEM\CurrentControlSet\Policies\Microsoft\FeatureManagement\Overrides" /v 4011992206 /t REG_DWORD /d 2 /f

:: Run scheduled tasks
powershell -Command ^
  "$TN='ReconcileFeatures'; $TP='\Microsoft\Windows\Flighting\FeatureConfig\';" ^
  "Enable-ScheduledTask $TN $TP | Out-Null;" ^
  "Start-ScheduledTask $TN $TP;" ^
  "while((Get-ScheduledTask $TN $TP).State.value__ -eq 4){Start-Sleep -s 1}; 'Task Completed'"

powershell -Command ^
  "$TN='UsageDataFlushing'; $TP='\Microsoft\Windows\Flighting\FeatureConfig\';" ^
  "Enable-ScheduledTask $TN $TP | Out-Null;" ^
  "Start-ScheduledTask $TN $TP;" ^
  "while((Get-ScheduledTask $TN $TP).State.value__ -eq 4){Start-Sleep -s 1}; 'Task Completed'"

echo.
echo [*] Consumer ESU feature enabled (Full Method).
echo [!] Please RESTART your computer NOW.
echo [!] After restart, run this script again and choose option 3 to check eligibility.
pause
goto :menu

:check
echo.
echo [*] Checking Consumer ESU eligibility...
for /f "tokens=3" %%A in ('reg query "HKCU\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Windows\ConsumerESU" /v ESUEligibility 2^>nul') do set ESU=%%A

if not defined ESU (
  color 06
  echo [!] ESUEligibility value not found. (Feature not active)
  echo Status: ^[Orange^]
) else (
  if "%ESU%"=="0x0" (
    color 06
    echo [!] ESUEligibility = %ESU% (Not enrolled)
    echo Status: ^[Orange^]
  ) else (
    color 0A
    echo [OK] ESUEligibility = %ESU% (Enrolled successfully!)
    echo Status: ^[Green^]
  )
)

echo.
cmd /c ClipESUConsumer.exe -evaluateEligibility
echo.
pause
goto :menu

:disable
echo.
echo [*] Disabling Consumer ESU feature...
reg.exe delete "HKLM\SYSTEM\CurrentControlSet\Policies\Microsoft\FeatureManagement\Overrides" /v 4011992206 /f

echo.
echo [*] Consumer ESU feature removed.
pause
goto :menu
